import { createAsyncThunk, createSlice } from '@reduxjs/toolkit';
import { queryResponse } from '../../../util/processResponse.js';

const initialState = {
    refundDetails: {},
    loading: true,
    messages: [],
    loadMessage: false,
    isRefresh: false,
};

export const getRefundDetails = createAsyncThunk(
    'user/getRefundDetails',
    async (dataObj) => {
        const { access_token, URL } = dataObj;
        const data = await queryResponse(URL, 'GET', access_token);
        return data;
    }
);
export const getRefundMessage = createAsyncThunk(
    'user/getMyRefundsMessage',
    async (dataObj) => {
        const { access_token, URL } = dataObj;
        const data = await queryResponse(URL, 'GET', access_token);
        return data;
    }
);

const getRefundDetailsSlice = createSlice({
    name: 'user',
    initialState,
    reducers: {
        getRefundMessageSuccree: (state, { payload }) => {
            const { status: { code } = {}, records } = payload;
            if (code === 200) {
                state.messages = records;
            }
        },
        pendingRefundMessage: (state) => {
            state.isRefresh = true;
        },
        getRefundDetailsSuccess: (state, { payload }) => {
            const { status: { code } = {}, records } = payload || {};
            if (code === 200) {
                state.refundDetails = records.data?.refund;
                state.messages = records?.data?.chat;
            }
            state.isRefresh = false;
        },
    },
    extraReducers: (builder) => {
        builder.addCase(getRefundDetails.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getRefundDetails.fulfilled, (state, { payload }) => {
            const { status: { code } = {}, records } = payload;
            if (code === 200) {
                state.refundDetails = records.data?.refund;
                state.messages = records?.data?.chat;
            }
            state.loading = false;
        });
        builder.addCase(getRefundDetails.rejected, (state) => {
            state.loading = false;
        });

        builder.addCase(getRefundMessage.pending, (state) => {
            state.loadMessage = false;
        });
        builder.addCase(getRefundMessage.fulfilled, (state, { payload }) => {
            const { status: { code } = {}, records } = payload || {};
            if (code === 200) {
                state.messages = records;
            }
            state.loadMessage = false;
        });
        builder.addCase(getRefundMessage.rejected, (state) => {
            state.loadMessage = false;
        });
    },
});

export const {
    getRefundMessageSuccree,
    pendingRefundMessage,
    getRefundDetailsSuccess,
} = getRefundDetailsSlice.actions;
export default getRefundDetailsSlice.reducer;
